#ifndef _IPROPERTYACTIONS_H_
#define _IPROPERTYACTIONS_H_
#include <Geometry/SimplexProperty.h>
#include <buildspec.h>
#include <string>
#include <vector>

namespace GST
{
namespace Geometry
{
class IGeometry;
}
namespace Parsers
{

class GST_API_EXPORT IPropertyActions
{
public:
	virtual ~IPropertyActions()
	{
	}

	virtual void PropAddValue(const std::string &value) = 0;

	virtual void PropAddNullValue()
	{
		this->PropAddValue("");
	}

	virtual void PropAddVector(const std::vector<std::string> &vector) = 0;

	virtual void PropAddNullVector()
	{
		this->PropAddVector(std::vector<std::string>());
	}

	virtual void PropNextObject() = 0;

	virtual int CreateVertexProperty(
		const std::string &name,
		const Geometry::SimplexProperty::PropertyType &PropertyType,
		const unsigned int &dims)
		= 0;

	virtual int CreateCellProperty(
		const std::string &name,
		const Geometry::SimplexProperty::PropertyType &PropertyType,
		const unsigned int &dims)
		= 0;
	/**
		This function will be called when parsing is finished successfully.
		\callergraph
	*/
	virtual void PropertyParsingFinished()
	{
	}
};

} // namespace Parsers
} // namespace GST

#endif //_IPROPERTYACTIONS_H_
